#include <windows.h>    // DriverLINX needs this
#include <iostream.h>
#include <conio.h>
#include "drvlinx.h"   /* DriverLINX API */
#include "dlcodes.h"   /* DriverLINX error codes and macros */
// be sure to add c:\drvlinx4\dlapi\drvlnxbc.lib to the project

// DriverLINX variables and function prototypes
DL_SERVICEREQUEST SR;    // declare the Service Request Structure
HANDLE hInstance;       // instance handle for the driver
HANDLE hWin;           // handle to this application
int portValue;         // value to write to port
// variables used for error handling
char errString[100];
DWORD size=50;
int errNumber;

void main()
{
   /*
     DriverLINX anticipates that message processing will be used
     so it requires a window handle to know which application
     should get the messages.

     In the case of simple polled mode operations, use of messages
     is not necessary.  In the case of Console (DOS box) application
     there is no window handle.  In these cases, give DriverLINX the
     handle of the Windows Desktop.  We'll never get any messages
     to this application, but we do not need them.
   */
   hWin = GetDesktopWindow();

   // call OpenDriverLINX()
	hInstance = (HANDLE)OpenDriverLINX( hWin, "kmbpio" );
   /*
      pass in your driver name to avoid OpenDriverLINX Dialog
      Use kmbpio for ISA bus digital I/O cards.
      Use kpciiso for the KPCI-PDISO8A or KPCI-PIO32IOA
      Use kpcipio for KPCI-PIO24 or KPCI-PIO96
      Use kpci3160 for KPCI-3160
   */

   // allocate our SR structure and init the members to zero
   memset( &SR, 0, sizeof( DL_SERVICEREQUEST ) );
	DL_SetServiceRequestSize( SR );

   // set some members
	SR.hWnd = hWin;  // set handle member to our Desktop handle
   SR.operation = INITIALIZE;  // carry out an initialization operation
	SR.device = 0;  // the device number assigned in DLinx Config Panel
	SR.subsystem = DEVICE;  // init the entire device
	SR.mode = OTHER;   // use OTHER mode for init operation
    	// call DriverLINX() to execute the task specified by the
if( DriverLINX( &SR ) != NoErr )
{// respond to error
          errNumber = getErrCode(SR.result);
          // errNumber corresponds to DriverLINX documentation
          ReturnMessageString(SR.hWnd,SR.result,errString,size);
          // errString corresponds to DriverLINX documentation
          cout << "Error Initializing Hardware\n";
          cout << errString;
          getch();  // pause
}
else
{
        /* all is well, allow digital output

        Need to modify members of the SR structure for a
        polled mode DO task.  Write a value between 0 and 255
        to control the state of the 8 DO lines

        NOTE:  this example does NOT first configure the channel
        for output direction.  Many boards, DAS-xxxx and some
        KPCI and some special purpose ISA boards, have digital
        channels that are fixed for input or output direction.  For
        these boards with a fixed channel direction, there is no need to first
        configure the channel for output direction.  You just use it.

        For other boards however, the digital I/O channels can be inputs
        or outputs.  They will be inputs by default, so require to be
        configured for output before you can write to them.  You will
        get an invalid channel in channel/gain list error when
        attempting to use a DO channel that has not yet been configured as DO.

        This is especially true for 82C55 based boards such as: PIO-12,
        PIO-24, PIO-96J, KPCI-PIO24, KPCI-PIO96, KPCI-3160.  It also
        applies to general purpose boards such as KPCI-3101, KPCI-3130
        or the digital on second connector of KPCI-3108

        The code below will accomplish a config if required:
        SR.subsystem = DO; // assign chan to DO direction
	     SR.mode = OTHER;
	     SR.operation = CONFIGURE;
        SR.timing.typeEvent = DIOSETUP;
	     SR.timing.u.diSetup.channel= iChan; // your channel number
	     SR.timing.u.diSetup.mode = DIO_BASIC;
        DriverLINX( &SR );

        */
   SR.subsystem = DO; // use the Digital Output subsystem of the board
	SR.mode = POLLED;
	SR.operation = START;
 	SR.channels.nChannels = 1;  // a single channel task
	SR.channels.chanGain[ 0 ].channel = 0;  // it is channel 0
   SR.taskFlags = NO_SERVICESTART | NO_SERVICEDONE; // send no messages
   /*
      read in value to be written to the channel (port)
   */
   cout << "Enter value between 0 and 255\n";
   cin >> portValue;
   SR.status.u.ioValue = portValue; // the value to write to the channel
   if( DriverLINX( &SR ) != NoErr )
         {// respond to error
          errNumber = getErrCode(SR.result);
         // errNumber corresponds to DriverLINX documentation
         ReturnMessageString(SR.hWnd,SR.result,errString,size);
         // errString corresponds to DriverLINX documentation
         cout << "Error writing value to port\n";
         cout << errString;
         getch();  // pause
          }
} // if/else init

cout << "Hit any key to exit\n";
getch();  // pause

// on exit, clean up
CloseDriverLINX(hInstance); //close the DriverLINX driver
hInstance=NULL; //for safety, make sure hInstance isn't pointing to anything
}    // main
